<?php

/*
 * ==========================================================
 * LINE APP
 * ==========================================================
 *
 * Line app. © 2017-2025 board.support. All rights reserved.
 *
 * 1. Send a message to Line
 * 2. Convert Support Board rich messages to Line rich messages
 * 3. Line curl
 *
 */

define('SB_LINE', '1.0.6');

function sb_line_send_message($line_id, $message = '', $attachments = [], $conversation_id = false) {
    if (empty($message) && empty($attachments)) {
        return false;
    }
    $user_id = defined('SB_DIALOGFLOW') ? sb_get_user_by('line-id', $line_id)['id'] : false;
    $response = false;
    $token = sb_isset(sb_db_get('SELECT extra_2 FROM sb_conversations WHERE id = ' . sb_db_escape($conversation_id)), 'extra_2'); // Deprecated
    if (empty($token) || str_contains($token, 'thread_')) { // Deprecated. Remove if.
        $token = sb_isset(sb_db_get('SELECT extra_3 FROM sb_conversations WHERE id = ' . sb_db_escape($conversation_id)), 'extra_3');
    } // Deprecated. Remove if.

    // Send the message
    $query = ['to' => $line_id];
    $message = sb_messaging_platforms_text_formatting($message);
    $message = sb_line_rich_messages($message, ['user_id' => $user_id]);
    $attachments = array_merge($attachments, $message[1]);
    if ($message[0] || $message[2]) {
        if ($message[0]) {
            $query['messages'] = [['type' => 'text', 'text' => $message[0]]];
        }
        if ($message[2]) {
            $query['messages'] = $message[2];
        }
        $response = sb_line_curl('message/push', $token, $query);
    }

    // Attachments
    $count = count($attachments);
    if ($count) {
        $messages = [];
        for ($i = 0; $i < count($attachments); $i++) {
            $url = $attachments[$i][1];
            $extension = substr($url, strripos($url, '.') + 1);
            switch ($extension) {
                case 'jpg':
                case 'jpeg':
                case 'png':
                    array_push($messages, ['type' => 'image', 'originalContentUrl' => $url, 'previewImageUrl' => $url]);
                    break;
                case 'mp4':
                    array_push($messages, ['type' => 'video', 'originalContentUrl' => $url, 'previewImageUrl' => SB_URL . '/media/thumb.png']);
                    break;
                default:
                    array_push($messages, ['type' => 'text', 'text' => $url]);
            }
        }
        $query['messages'] = $messages;
        $response = sb_line_curl('message/push', $token, $query);
    }
    return ['error' => empty($response) || isset($response['sentMessages']) ? false : $response];
}

function sb_line_rich_messages($message, $extra = false) {
    $messages = [];
    $message = sb_clear_text_formatting($message);
    $shortcodes = sb_get_shortcode($message);
    $attachments = [];
    for ($j = 0; $j < count($shortcodes); $j++) {
        $shortcode = $shortcodes[$j];
        $shortcode_id = sb_isset($shortcode, 'id', '');
        $shortcode_name = $shortcode['shortcode_name'];
        $message = trim((isset($shortcode['title']) ? ' *' . sb_($shortcode['title']) . '*' : '') . PHP_EOL . sb_(sb_isset($shortcode, 'message', '')) . str_replace($shortcode['shortcode'], '{R}', $message));
        $message_inner = '';
        switch ($shortcode_name) {
            case 'slider-images':
            case 'slider':
            case 'card':
                $cards = [];
                if ($shortcode_name == 'slider-images') {
                    $images = explode(',', $shortcode['images']);
                    for ($i = 0; $i < count($images); $i++) {
                        array_push($cards, ['imageUrl' => $images[$i], 'action' => ['type' => 'postback', 'label' => ' ', 'data' => '#']]);
                    }
                    array_push($messages, ['type' => 'template', 'altText' => 'Error', 'template' => ['type' => 'image_carousel', 'columns' => $cards]]);
                } else {
                    $index = $shortcode_name == 'slider' ? 1 : 0;
                    while (isset($shortcode['image' . ($index ? '-' . $index : '')])) {
                        $suffix = $index ? '-' . $index : '';
                        $text = $shortcode['description' . $suffix] . PHP_EOL . sb_isset($shortcode, 'extra' . $suffix, '');
                        if (strlen($text) > 60) {
                            $text = substr($text, 0, 57) . '...';
                        }
                        array_push($cards, ['thumbnailImageUrl' => sb_isset($shortcode, 'image' . $suffix), 'title' => $shortcode['header' . $suffix], 'text' => $text, 'actions' => [['type' => 'uri', 'label' => sb_isset($shortcode, 'link-text' . $suffix), 'uri' => sb_isset($shortcode, 'link' . $suffix)]]]);
                        $index++;
                    }
                    array_push($messages, ['type' => 'template', 'altText' => 'Error', 'template' => ['type' => 'carousel', 'columns' => $cards]]);
                }
                break;
            case 'list-image':
            case 'list':
                $index = $shortcode_name == 'list-image' ? 1 : 0;
                $values = explode(',', str_replace(['\://', '://', '\:', "\n,-", '\,'], ['{R2}', '{R2}', '{R4}', ' ', '{R3}'], $shortcode['values']));
                $is_numeric = !empty($shortcode['numeric']);
                if (strpos($values[0], ':')) {
                    for ($i = 0; $i < count($values); $i++) {
                        $value = explode(':', str_replace('{R3}', ',', $values[$i]));
                        $message_inner .= PHP_EOL . ($is_numeric ? ($i + 1) . '. ' : '•') . ' *' . trim($value[$index]) . '*: ' . trim($value[$index + 1]);
                    }
                } else {
                    for ($i = 0; $i < count($values); $i++) {
                        $message_inner .= PHP_EOL . ($is_numeric ? ($i + 1) . '. ' : '•') . ' ' . trim(str_replace('{R3}', ',', $values[$i]));
                    }
                }
                $message = trim(str_replace(['{R2}', '{R}', "\r\n\r\n\r\n", '{R4}'], ['://', str_replace(['{R2}', '{R4}'], ['://', '\:'], $message_inner) . PHP_EOL . PHP_EOL, "\r\n\r\n", ':'], $message));
                break;
            case 'select':
            case 'buttons':
            case 'chips':
                $values = explode(',', $shortcode['options']);
                $buttons = [];
                $count = count($values);
                if ($count > 13) {
                    $count = 13;
                }
                for ($i = 0; $i < $count; $i++) {
                    $value = explode('|', $values[$i])[0];
                    array_push($buttons, ['type' => 'action', 'action' => ['type' => 'message', 'label' => substr($value, 0, 20), 'text' => $value]]);
                }
                array_push($messages, ['type' => 'text', 'text' => $message, 'quickReply' => ['items' => $buttons]]);
                $message = '';
                if ($shortcode_id == 'sb-human-takeover' && defined('SB_DIALOGFLOW')) {
                    sb_dialogflow_set_active_context('human-takeover', [], 2, false, sb_isset($extra, 'user_id'));
                }
                break;
            case 'share':
            case 'button':
                $message = sb_clear_text_formatting(str_replace('{R}', $shortcode['link'], $message));
                break;
            case 'video':
                $message = sb_clear_text_formatting(str_replace('{R}', $shortcode['type'] == 'youtube' ? 'https://www.youtube.com/embed/' : 'https://player.vimeo.com/video/', $message));
                break;
            case 'image':
                $attachments = [[$shortcode['url'], $shortcode['url']]];
                break;
            case 'rating':
                $labels = [sb_isset($shortcode, 'label-positive'), sb_isset($shortcode, 'label-negative')];
                if ($labels[0] && $labels[1]) {
                    $buttons = [];
                    for ($i = 0; $i < 2; $i++) {
                        array_push($buttons, ['type' => 'action', 'action' => ['type' => 'message', 'label' => substr($labels[$i], 0, 20), 'text' => $labels[$i]]]);
                    }
                    array_push($messages, ['type' => 'text', 'text' => $message, 'quickReply' => ['items' => $buttons]]);
                    $message = '';
                }
                if (defined('SB_DIALOGFLOW')) {
                    sb_dialogflow_set_active_context('rating', [], 2, false, sb_isset($extra, 'user_id'));
                }
                break;
            case 'articles':
                if (isset($shortcode['link'])) {
                    $message = sb_clear_text_formatting(str_replace('{R}', $shortcode['link'], $message));
                }
                break;
        }
    }
    return [str_replace('{R}', '', $message), $attachments, $messages];
}

function sb_line_curl($url_part, $token, $query = '', $method = 'POST') {
    $response = sb_curl('https://api.line.me/v2/bot/' . $url_part, $query ? json_encode($query) : '', ['Content-Type: application/json', 'Authorization: Bearer ' . $token], $method);
    return $method == 'GET' ? json_decode($response, true) : $response;
}

?>